/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MergeInfrequentNominalValues;

public class MergeInfrequentNominalValuesTest
extends AbstractFilterTest {
    public MergeInfrequentNominalValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MergeInfrequentNominalValues f = new MergeInfrequentNominalValues();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testDifferentRange() {
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(5);
        ((MergeInfrequentNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(4) == 1.0 || this.m_Instances.instance(i).value(4) == 2.0) {
                if (mergedIndex == -1) {
                    mergedIndex = (int)result.instance(i).value(4);
                } else {
                    MergeInfrequentNominalValuesTest.assertEquals("Checking merged value for instance: " + (i + 1), mergedIndex, (int)result.instance(i).value(4));
                }
            }
            ++i;
        }
    }

    public void testMergeAll() {
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(100);
        ((MergeInfrequentNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        MergeInfrequentNominalValuesTest.assertEquals(1, result.attribute(1).numValues());
        MergeInfrequentNominalValuesTest.assertEquals(1, result.attribute(4).numValues());
    }

    public void testAttributeWithMissing() {
        ((MergeInfrequentNominalValues)this.m_Filter).setAttributeIndices("5");
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(100);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                MergeInfrequentNominalValuesTest.assertTrue("Missing in input should give missing in result", result.instance(i).isMissing(4));
            } else if (this.m_Instances.instance(i).value(4) == 1.0 || this.m_Instances.instance(i).value(4) == 2.0) {
                if (mergedIndex == -1) {
                    mergedIndex = (int)result.instance(i).value(4);
                } else {
                    MergeInfrequentNominalValuesTest.assertEquals("Checking merged value for instance: " + (i + 1), mergedIndex, (int)result.instance(i).value(4));
                }
            }
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((MergeInfrequentNominalValues)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MergeInfrequentNominalValuesTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeInfrequentNominalValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MergeInfrequentNominalValuesTest.suite());
    }
}

